function p1 = find_root()
% FIND_ROOT Find the root path of the current script or function file
%   This function returns the full directory path of the current file.

    % Get the full path of the current script or function file
    p1 = mfilename('fullpath');

    % Find all positions of backslash "\" in the full path (Windows path separator)
    i = strfind(p1, '\');

    % Keep only the directory part of the path (remove filename)
    p1 = p1(1:i(end));
end
